	subroutine SHAPEB(iout, idbg, Ne, Nn, Nb, Sx, BCe, Bci, ie, x, &
			  Jib, Shpb, dNdrb)
! calculate element shape functions on boundary faces
! note that on element boundaries W=N

	implicit none
	integer iout, idbg
	integer Ne, Nn, Nb			! array parameters
	real*8 Sx
	integer BCe(Nb,2), BCi(Nb)		! BC element and local element face numbers
	integer ie(Ne,3)			! global connectivity array
	real*8 x(Nn,1)				! global coordinates array
	real*8 Jib(1,1,Nb,1)			! boundary geometric entities
	real*8 Shpb(1,Nb,1), dNdrb(1,1,Nb,1)	! boundary shape functions

	integer e, Ln1, Lf, n, g1b, i, k, ii
	real*8 Jb(1,1), Jacb, Jacib
	real*8 Shp(2), dNdr(2,1)
	real*8 r

!	write(idbg,'(a)') ' --- SHAPEB ---'	! ### TEMPORARY ###
! linear 1D shape functions
! Ni(r) = (1 +/- r) / 2 ; -1 < r < +1
	do n = 1, Nb
	  e  = BCe(n,2)		! BC element number
	  Lf = BCi(n)		! BC local face number

	  if     (Lf .eq. 1) then		! face 1, r=-1
	    r =-1
	    Ln1 = 1				! local node 1
	  else if(Lf .eq. 2) then		! face 2, r=+1
	    r = 1
	    Ln1 = 2				! local node 1
	  endif

	  do g1b = 1, 1

	    Shp(1) = 0.5d0 * (1.-r)		! N1(r)
	    Shp(2) = 0.5d0 * (1.+r)		! N2(r)

	    dNdr(1,1) =-0.5d0			! dN1(r)/dr
	    dNdr(2,1) = 0.5d0			! dN2(r)/dr

! Jb(i,j) the Jacobian matrix
	    Jb = 0.				! reset Jb, use matrix form 
	    do i = 1,1
	      do k = 1,1
	        do ii = 1,2
		  Jb(i,k) = Jb(i,k) + dNdr(ii,k) * x(ie(e,ii), i )
	        enddo	! ii
	      enddo	! k
	    enddo	! i

	    Jacb = Jb(1,1)			! Jacobian determinant, |J|
	    Jacib = 1. / Jacb			! 1/|J|

! inv{Jb(i,j)}
	    Jib(1,1,n,g1b) = Jb(1,1)*Jacib
! store
	    Shpb(1,n,g1b) = Shp(Ln1)		! N_I at node 1
	    dNdrb(1,1,n,g1b) = dNdr(Ln1,1)	! dN_I/dr at node 1

	  enddo	! g1b

	enddo	! n
	
	return
	end
